#!/bin/sh

MASTER_PAGE_SB_REINSTALL_RESULT_MSG=""
MASTER_PAGE_SB_REINSTALL_RESULT_OK=0
MASTER_PAGE_SB_REINSTALL_RESULT_ERROR=1

MASTER_PAGE_SB_REINSTALL_RESULT_CODE=${MASTER_PAGE_SB_REINSTALL_RESULT_ERROR}
MASTER_PAGE_SB_REINSTALL_RESULT_ROLLING=0

usr1_signal_handler() {
	# get percentage and trim blank (if any)
	deployment_percentage=`sed -n '1p' "${CONS_DEPLOYMENT_STATUS_FILE}" | awk '{print $1}'`
	sed -i '1d' "${CONS_DEPLOYMENT_STATUS_FILE}"
	local counter=1
	deployment_progress_status=""
	while read line
	do
		if [ "${counter}" -eq 1 ]; then
			line="\\Z0${line}"
			counter=2
		else
			counter=1
		fi
		deployment_progress_status="${deployment_progress_status} \"${line}\""
	done < "${CONS_DEPLOYMENT_STATUS_FILE}"
}

master_page_sb_reinstall_cleanup() {
    rm -f "${CONS_DEPLOYMENT_STATUS_FILE}"
    
    utility_close_esxi_service_sshd \
        "${RT_ESXI_IP:-$conf_esxi_ip}" \
        "${RT_ESXI_USERNAME:-$conf_esxi_username}" \
        "${RT_ESXI_PASSWORD:-$conf_esxi_password}"

    utility_accept_ctrl_c
}

master_page_sb_reinstall() {
	debug_print "in function '${FUNCNAME[0]}'"
    
	local deploy_step_file="re_deployment.step"
	trap 'usr1_signal_handler' SIGUSR1
    
	utility_reject_ctrl_c
    
    utility_open_esxi_service_sshd \
        "${RT_ESXI_IP:-$conf_esxi_ip}" \
        "${RT_ESXI_USERNAME:-$conf_esxi_username}" \
        "${RT_ESXI_PASSWORD:-$conf_esxi_password}"
    if [ "${?}" -ne 0 ]; then
        utility_accept_ctrl_c
        
        MASTER_PAGE_SB_REINSTALL_RESULT_CODE=${MASTER_PAGE_SB_REINSTALL_RESULT_ERROR}
        MASTER_PAGE_SB_REINSTALL_RESULT_MSG="${MASTER_PAGE_SB_REINSTALL_CALLING_DEPLOY_ERROR}: msg='${UTILITY_OPEN_ESXI_SERVICE_SSHD_MSG}'"
        MASTER_PAGE_SB_REINSTALL_RESULT_ROLLING=-1
        return
    fi
    
    local mainScript="${CONS_ECLI_DIR}deploy.sh"
    local ppid="${$}"
    local statusFile="${CONS_DEPLOYMENT_STATUS_FILE}"
    local stepFile="${CONS_ECLI_DIR}${deploy_step_file}"
    
    debug_print "start to 'Add/Remove sandboxes': script='${mainScript}', ppid='${ppid}', statusFile='${statusFile}', stepFile='${stepFile}'"
    ${mainScript} "${ppid}" "${statusFile}" "${stepFile}" 1>/dev/null 2>&1 &
    local retCode="${?}"
    if [ "${retCode}" -eq 1 ]; then
        local msg="LaunchMainScriptFail: mainScript='${mainScript}', retCode='${retCode}'"
        debug_print "${msg}"
        
        master_page_sb_reinstall_cleanup
        
        MASTER_PAGE_SB_REINSTALL_RESULT_CODE=${MASTER_PAGE_SB_REINSTALL_RESULT_ERROR}
        MASTER_PAGE_SB_REINSTALL_RESULT_MSG="${MASTER_PAGE_SB_REINSTALL_CALLING_DEPLOY_ERROR}: msg='${msg}'"
        MASTER_PAGE_SB_REINSTALL_RESULT_ROLLING=-1
        return
    fi
    
    # these two variables will be updated by 'signal_handler'
    local deployment_percentage=0
    local deployment_progress_status="'' ''"
    

    while [ "${deployment_percentage}" -lt 100 ];
    do
    
        # error handling
        # debug_print "deployment_percentage='${deployment_percentage}'"
        if [ "${deployment_percentage}" -eq -1 ]; then
            local msg=`cat ${statusFile}`
            debug_print "DeploymentFail: msg='${msg}'"
            
            master_page_sb_reinstall_cleanup
            MASTER_PAGE_SB_REINSTALL_RESULT_CODE=${MASTER_PAGE_SB_REINSTALL_RESULT_ERROR}
            MASTER_PAGE_SB_REINSTALL_RESULT_MSG="${MASTER_PAGE_SB_REINSTALL_DEPLOYING_ERROR}: msg='${msg}'"
            MASTER_PAGE_SB_REINSTALL_RESULT_ROLLING=-1
            return
        fi
        
        # bring out tUI
        tp_mixedgauge \
            "${MASTER_PAGE_SB_REINSTALL_TITLE}" \
            "${MASTER_PAGE_SB_REINSTALL_SUBTITLE}" \
            "${deployment_percentage}" \
            "${deployment_progress_status}"

        sleep 1
    done
    
    master_page_sb_reinstall_cleanup
    MASTER_PAGE_SB_REINSTALL_RESULT_CODE=${MASTER_PAGE_SB_REINSTALL_RESULT_OK}
    MASTER_PAGE_SB_REINSTALL_RESULT_MSG=""
    MASTER_PAGE_SB_REINSTALL_RESULT_ROLLING=1
    return
}